<?php defined('SYSPATH') or die('No direct script access.');

class Add_menu_title_column_to_actions_table extends Migration
{
    public $schema = 'public';
    public $table = 'actions';

    public function up()
    {
        $this->add_column($this->table, 'menu_title', ['string', 'length' => 32, 'null' => false, 'default' => '']);
        
        $actions = ORM::factory('Action')->find_all();
        foreach($actions as $action)
        {
            $action->menu_title = $action->description;
            $action->save();
        }
        
        $this->run_query("ALTER TABLE $this->table ALTER COLUMN menu_title DROP DEFAULT");
    }

    public function down()
    {
        $this->remove_column($this->table, 'menu_title');
    }
}